# license: Creative Commons Attribution 4.0 International (CC BY 4.0), http://creativecommons.org/licenses/by/4.0/
# Citation: Latypova E., Corbi F., Mastella G., Funiciello F., Moreno M., Bedford J. (2025): Data and scripts from Neighbouring segments control on earthquake recurrence patterns: Insights from scaled seismotectonic models. GFZ Data Services. https://doi.org/10.5880/fidgeo.2025.046
#
#!/usr/bin/env python3
# -*- coding: utf-8 -*-
"""
Created on Mon Oct  7 15:31:32 2024

@author: elya
"""

import numpy as np
import matplotlib.pyplot as plt
import pandas as pd

############################################################
### IMPORTANT to define a working directory with all the data 
### in Linux something like: /GRL_data_scripts_latypova_et_al, 2025/data
## load data

#### center of the long asp
p1u_df = pd.read_csv('40_40Pa_long_fixed_center_of_long_asp.csv')
p1u = p1u_df.values  # Convert to numpy array if needed

#### center of the short asp
p2u_df = pd.read_csv('40_40Pa_long_fixed_center_of_short_asp.csv')
p2u = p2u_df.values  # Convert to numpy array if needed

frames = np.arange(0, 4500)  
seconds = frames / 50.0  
fig = plt.figure(figsize=(20, 10))
gs = fig.add_gridspec(2, 2)


ax1 = fig.add_subplot(gs[0, :])

ax1.plot(seconds, p1u, label='center of long asp', color='#77AC30')
ax1.plot(seconds, p2u, label='center of short asp', color='#D95319')

ax1.set_xlim([0, max(seconds)])
#ax2.set_ylim([-2, 2])
ax1.legend()
#ax1.legend(['center of long asperity', 'center of short asperity'])
ax1.set_title('Time series plot for asymmetric along-strike asperities with a fixed 40 Pa long asperity and 40 Pa short asperity', fontsize=15)
ax1.set_xlabel('time, seconds',fontsize=14)
ax1.set_ylabel('Velocity cm/s', fontsize=14)
ax1.tick_params(axis='both', which='major', labelsize=13) 




ax2 = fig.add_subplot(gs[1, :])
ax2.plot(seconds, -np.cumsum(p1u), label='center of long asp', color='#77AC30')
ax2.plot(seconds, -np.cumsum(p2u), label='center of short asp', color='#D95319')

ax2.set_xlim([0, max(seconds)])
#ax2.set_ylim([-2, 2.2])
ax2.legend()
#ax2.legend(['center of long asperity', 'center of short asperity'])
ax2.set_title('Cumsums plot for asymmetric along-strike asperities with a fixed 40 Pa long asperity and 40 Pa short asperity', fontsize=15)
ax2.set_xlabel('time, seconds',fontsize=14)
ax2.set_ylabel('cumulative value of V', fontsize=14)
ax2.tick_params(axis='both', which='major', labelsize=13) 







plt.tight_layout()
plt.show()
